#include <iostream>
#include <vector>
#include <unordered_map>
#include <map>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    // Step 1: Prefix sum
    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, int> first, last;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i])) first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    //ovde namestam 
    map<long long, int> namestam;
    int id = 0;
    for (long long x : a)
        if (!namestam.count(x))
            namestam[x] = id++;

    int K = id; //broj jedinstvenih

    // ova prefiksna tabla za 25 poena
    vector<vector<int>> freq(n + 1, vector<int>(K, 0));
    for (int i = 0; i < n; ++i) {
        freq[i + 1] = freq[i];
        freq[i + 1][namestam[a[i]]]++;
    }

    int res = 0;
    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;

        int local_max = 0;
        for (int k = 0; k < K; ++k) {
            int cnt = freq[r][k] - freq[l][k];
            local_max = max(local_max, cnt);
        }

        res = max(res, local_max);
    }

    cout << res << '\n';
    return 0;
}